//============================
// C" First Person Driving
//============================


// ===== INCLUDES =======
#include <a_samp>
#include <zcmd>
// =======================

// ===== VARIABLE ========
new Camera[MAX_PLAYERS];
new Allow[MAX_PLAYERS];
// =======================

// ============================== SCRIPT START =================================


#if defined FILTERSCRIPT

public OnFilterScriptInit()
{
	print("\n--------------------------------------");
	print(" Champ's First Person Driving Loaded");
	print("--------------------------------------\n");
	return 1;
}

public OnFilterScriptExit()
{
	return 1;
}

#else

#endif

public OnPlayerConnect(playerid)
{
    Camera[playerid] = CreateObject(19300, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    Allow[playerid] = 0;
	return 1;
}

public OnPlayerDisconnect(playerid, reason)
{
    DestroyObject(Camera[playerid]);
	return 1;
}

public OnPlayerEnterVehicle(playerid, vehicleid, ispassenger)
{
	if(Allow[playerid] ==1)
 	{
 	    new playerState = GetPlayerState(playerid);
		AttachObjectToVehicle(Camera[playerid], vehicleid, 0.0, 0.15, 0.65, 0.0, 0.0, 0.0);
		AttachCameraToObject(playerid, Camera[playerid]);
		
		if (playerState == PLAYER_STATE_PASSENGER)
    	{
		    SetCameraBehindPlayer(playerid);
        }
		
	}
	else
	{
	    SetCameraBehindPlayer(playerid);
	}
	return 1;
}

public OnPlayerExitVehicle(playerid, vehicleid)
{
    SetCameraBehindPlayer(playerid);
	return 1;
}

public OnPlayerStateChange(playerid, newstate, oldstate)
{
	if(oldstate == PLAYER_STATE_DRIVER)
 	{
  		if(newstate == PLAYER_STATE_ONFOOT)
    	{
   			SetCameraBehindPlayer(playerid);
		}
  	}
	return 1;
}

CMD:cfpdon(playerid, params[])
{
	SendClientMessage(playerid, -1,"You have {FF0000}ENABLED {FFFFFF}First Person Driving on next vehicle enter.");
	Allow[playerid] = 1;
    return 1;
}

CMD:cfpdoff(playerid, params[])
{
    SendClientMessage(playerid, -1,"You have {FF0000}DISABLED {FFFFFF}First Person Driving on next vehicle enter.");
    Allow[playerid] = 0;
    return 1;
}



// ================================ SCRIPT END =================================
